﻿using System;
using System.Threading;

namespace VBECS.Services.Common.Timing
{
    public class SynchronousServer : ServerBase
    {
        public SynchronousServer(int timeOut) : base(timeOut)
        {
        }

        public override event EventHandler<EventArgs> TimeoutElapsed;

        protected override void do_start(CancellationToken token)
        {
            while (!token.IsCancellationRequested)
            {
                if (!token.WaitHandle.WaitOne(TimeOut*1000))
                {
                    // ''timeout' period elapsed - do some periodic work here.
                    fire_timeout_elapsed_event();
                }
            }
            Console.WriteLine("Canceled while running.");
            token.ThrowIfCancellationRequested();
        }

        private void fire_timeout_elapsed_event()
        {
            if (null != TimeoutElapsed)
            {
                TimeoutElapsed.Invoke(this, new EventArgs());
            }
        }
    }
}
